Unit pcRandomString;

Interface
Uses windows, sysutils;
Type
  TRandomStringType = (rsAllSymbols, rsAlphaNumeric, rsAlpha, rsNumeric);

Function RandomString(iLength: Integer; iType: TRandomStringType): String;

Implementation

Function RandomString(iLength: Integer; iType: TRandomStringType): String;
Var
  strReturn         : String;
  iNumber, i        : integer;
Begin
  For i := 0 To iLength Do
    Begin
      // Seed the random-number generator with TickCount so that
      // the numbers will be different every time we run.
      randseed:=((i + 1) * iLength * GetTickCount());

      Case iType Of

        rsAlphaNumeric:
          Begin
            iNumber := Round(Random(2550) / 122);
            If (48 > iNumber) Then
              iNumber := iNumber + 48;
            If ((57 < iNumber) And (65 > iNumber)) Then
              iNumber := iNumber + 7;
            If ((90 < iNumber) And (97 > iNumber)) Then
              iNumber := iNumber + 6;
            strReturn := strReturn + char(iNumber);
          End;
        rsAlpha:
          Begin
            iNumber := Round(Random(2550) / 122);
            If (65 > iNumber) Then
              iNumber := 65 +iNumber;//+ Round(iNumber / 56);
            If ((90 < iNumber) And (97 > iNumber)) Then
              iNumber := iNumber + 6;
            strReturn := strReturn + char(iNumber);
          End;
        rsNumeric:
          strReturn := strReturn + inttostr(Round(Random(10)));
        Else
          strReturn := strReturn + char(Round(Random(255)));
      End;

      Result := strReturn;
    End;
  end;

initialization
   Randomize;

End.

